// Copyright (C) 2014 Klaralvdalens Datakonsult AB (KDAB).
// SPDX-License-Identifier: LicenseRef-Qt-Commercial

#ifndef QT3DRENDER_RENDER_QUICK_QUICK3DPARAMETER_P_H
#define QT3DRENDER_RENDER_QUICK_QUICK3DPARAMETER_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of other Qt classes.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <Qt3DRender/qparameter.h>

#include <Qt3DQuickRender/private/qt3dquickrender_global_p.h>

#include <QtQml/qqmlregistration.h>

QT_BEGIN_NAMESPACE

namespace Qt3DRender {
namespace Render {
namespace Quick {

class Quick3DParameterPrivate;

class Q_3DQUICKRENDERSHARED_PRIVATE_EXPORT Quick3DParameter : public QParameter
{
    Q_OBJECT
    QML_NAMED_ELEMENT(Parameter)
    QML_ADDED_IN_VERSION(2, 0);

public:
    explicit Quick3DParameter(QNode *parent = nullptr);

private:
    Q_DECLARE_PRIVATE(Quick3DParameter)

protected:
    Quick3DParameter(Quick3DParameterPrivate &dd, QNode *parent = nullptr);
};

} // namespace Quick
} // namespace Render
} // namespace Qt3DRender

QT_END_NAMESPACE

#endif // QT3DRENDER_RENDER_QUICK_QUICK3DPARAMETER_P_H
